<?php 
   /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "classi/MetroSlider.php";
    
    if(isset($_GET["id"])) {
        $metroSlider = new MetroSlider($geecomDb, filter_input(INPUT_GET, "id",FILTER_SANITIZE_NUMBER_INT));
        $metroSlider->caricaDatiDalDatabase();
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
    
    $arrayTipiSlide = array("ultimiArticoli"=>"Ultimi articoli inseriti","categorie"=>"Ultimi articoli delle categorie indicate","contenuti"=>"Contenuti specifici");
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione metro slider</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Metro slider creato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        
                        if($status==250) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Metro slider modificato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                    ?>
                    <div class="col-12">
                        <div class="card mb-4 box-shadow-lite">
                            <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                <input type="text" class="d-none" name="operazione" value="<?php echo((isset($metroSlider) ? "modifica" : "crea")); ?>">
                                <input type="text" class="d-none" name="id" value="<?php echo((isset($metroSlider) ? $metroSlider->getId() : "0")); ?>">
                                
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-12 col-md-6 d-md-flex">
                                            <h6 class="mt-2 mr-2">MetroSlider:</h6>
                                            <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome Slider" value="<?php echo((isset($metroSlider) ? $metroSlider->getNome() : "")) ?>" placeholder="Nome lista">
                                        </div>
                                        <div class="col text-right">
                                            <a class="btn btn-outline-primary mt-2 mt-md-0" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                            <button class="btn btn-primary mt-2 mt-md-0"><i class="fas fa-check"></i> Salva</button>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="card-body">
                                    <div class="row">
                                       
                                        <div class="col-md-3 form-group">
                                            <label for="inputPassword3" >Spazio occupato</label>
                                            <select class="form-control" name="spazioOccupato">
                                            <?php 
                                                foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                    if(isset($metroSlider) && $metroSlider->getSpazioOccupato()==$classe) {
                                                        echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$classe\">$descrizione</option>";
                                                    }
                                                }
                                            ?>
                                            </select>
                                            <small class="text-muted">Lo spazio orizzontale occupato dall'elemento</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label for="inputPassword3" >Articoli per slide</label>
                                            <select class="form-control" name="articoliPerSlide">
                                            <?php 
                                                $articoliPerSlide = array(3,5);
                                                foreach($articoliPerSlide as $numeroArticoli) {
                                                    if(isset($metroSlider) && $metroSlider->getArticoliperSlide()==$numeroArticoli) {
                                                        echo"<option value=\"$numeroArticoli\" selected>$numeroArticoli</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$numeroArticoli\">$numeroArticoli</option>";
                                                    }
                                                }
                                            ?>
                                            </select>
                                            <small class="text-muted">Il numero di articoli visibili in ogni slide</small>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <div class="card-footer">
                                <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                        <div class="card mb-4 box-shadow-lite">
                            <?php 
                                if(isset($metroSlider)) {
                            ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-4 col-xl-3 align-self-start sticky-top">
                                        <form>
                                            <div class="mb-4 add-box">
                                                <h6 class="mb-3"> Aggiungi slide </h6>
                                                <div class="options-box">
                                                    <div class="form-group">
                                                        <label>Nome</label>
                                                        <input type="text" class="form-control" id="nomeElemento" placeholder="Nome">
                                                    </div>

                                                    <div class="form-group">
                                                        <label>Tipo</label>
                                                        <select class="form-control" id="tipoElemento">
                                                        <?php 
                                                            foreach($arrayTipiSlide as $tipo=>$etichetta) {
                                                                echo"<option value=$tipo \">$etichetta</option>";
                                                            }
                                                        ?>
                                                        </select>
                                                        <small class="form-text text-muted">Scegli il tipo di slide tra quelli disponibili</small>
                                                    </div>

                                                    <button type="button" class="btn btn-primary float-right" value="Crea" onclick="creaElemento()"><i class="fas fa-plus mr-2"></i>Crea</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>

                                    <div id="divElencoElementi" class="col-lg-8 col-xl-9 mb-4 gerarchia-menu">
                                        <?php 
                                            $metroSlider->stampaElementi();
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                                }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <?php
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../include/modal/eliminaElemento.php";
            
            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>

        <script>
            function eliminaElemento(id,nomeElemento,tipoElemento) {
                $('#elementoDaEliminare').val(id);
                $('#nomeElementoDaEliminare').text(nomeElemento);
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneElemento() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaElemento",
                        id:<?php echo $metroSlider->getId() ?>,
                        idElemento:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            document.getElementById("elementoComponente"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function spostaElementoInput(id) {
                var posizione = $('#nuovaPosizioneElemento'+id).val();
                spostaElemento(id,posizione);
            }
            
            function spostaElemento(id,posizione) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"spostaElemento",
                        id:<?php echo $metroSlider->getId() ?>,
                        idElemento:id,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function creaElemento() {
                var nome = $('#nomeElemento').val();
                var tipo = $('#tipoElemento').val();
                
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"creaElemento",
                        id:<?php echo $metroSlider->getId() ?>,
                        nome:nome,
                        tipo:tipo
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert("Si è verificato un errore, contatta l'amministratore del sito")
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaDivElementi() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"stampaElementi",
                        id:<?php echo $metroSlider->getId() ?>
                    },
                    success:function(result) {
                        document.getElementById("divElencoElementi").innerHTML = result;
                        $('#modifica-voce-menu').modal('hide');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
    </body>
</html>
